import unittest
from calendar import *
import os.path

class TestMeetings(unittest.TestCase):
    def setUp(self):
        self.m=Meeting('test',{},[])#define m to be shared between our test
        self.agenda1 = [None,'Welcome', "Apologies", 'Review Minutes of last meeting', 'Financial reports', 'Building proposal',
           'Review of OHS standards','Other Business']
        self.agenda2 = [None,"Welcome", "Dinner Service", "Guest Speaker", "Award Ceremony", "Conclusion"]
        self.attendees = {'Bella Fullilove','Ardella Gaillard','Yu Fiedler','Omega Bromley','Idell Bumpers'
             ,'Mahalia Marois','Reatha Riehl','Na Brinkman','Vicky Alvarez'}
        self.executive = {'Gala Peel','Bella Fullilove','Ardella Gaillard'}
        self.meetings = [Meeting('Executive Meeting',self.agenda1,self.executive)
            ,Meeting("Annual Awards Night",self.agenda2,self.attendees)
            ,Meeting('Social Get Together',[],self.attendees)]
        
        
    def test_create_meetings(self):
        m=Meeting('test',{},[])#test we can create a meeting.
        m.name()#test that this object has a name() function
        #m.name()==''#attempt to test that name of meeting - should fail but doesn't
                    #because it is testing that function would run in this context not result
        self.assertEqual(m.name(),'test')#use assertions to test behaviour
        #self.assertEqual(m.name(),'test')#succeeds
        #self.assertEqual(m.name(),'')#fails

    def test_is_meeting_type(self):
        m=Meeting('test',{},[])#test we can create a meeting.
        self.assertIsInstance(m,(Meeting))#Use assert instead
        #self.assertIsInstance(m,(str))#Test that it fails

    def test_name_function_behaviour(self):
        #make a separate test function for test name() returns 'test'
        #self.assertEqual(m.name(),'test')#fails because m is not defined
        self.assertEqual(self.m.name(),'test')#use setUp to define data in our tests.

    def test_getter_functions(self):
        meetingName=self.meetings[0].name()
        self.assertEqual(meetingName,'Executive Meeting')
        agendaList = self.meetings[0].agenda()
        self.assertEqual(agendaList,[None,'Welcome', "Apologies",
                                     'Review Minutes of last meeting', 'Financial reports', 'Building proposal',
                                     'Review of OHS standards','Other Business'])
        attendeesList = self.meetings[0].attendees()
        self.assertEqual(attendeesList,{'Gala Peel','Bella Fullilove','Ardella Gaillard'})

    @unittest.skip('Test no longer required')
    def test_printMeetings_exist(self):
        #self.m.printMeetings(meetings)#Why does this not work? This is a function in the calendar module not meetings class
        #printMeetings(meetings)#Why does this not work? This function is in the calendar module not the TestMeetings class
        #calendar.printMeetings(meetings)#Why does this not work? We have not imported the whole calendar module, only the Meetings
        #Importing calendar will not give us access to Meeting funcitons, we need to import both Meetings and Calendar
        printMeetings(self.meetings)

    @unittest.skip('Test no longer required')        
    def test_findMeetings(self):
        #test for existance of the calendar funcitons
        printMeetings(self.meetings)
        findMeetings(self.meetings,'Bella Fullilove')
    
    def test_findMeetingBehaviour(self):
        #Test for expected result
        self.assertEqual([m.name() for m in findMeetings(self.meetings,'Bella Fullilove')],
                         ['Executive Meeting', 'Annual Awards Night', 'Social Get Together'])
        #Also good to test for cases that might occur which are wrong.
        self.assertNotEqual([m.name() for m in findMeetings(self.meetings,'Bella Fullilove')],
                            ['Executive Meeting', 'Annual Awards Night'])
        
    def test_addAttendeesBehaviour(self):
        self.meetings[0].addAttendee('Matthew Gregory')
        self.assertEqual(self.meetings[0].attendees(),
                         {'Matthew Gregory', 'Gala Peel', 'Ardella Gaillard', 'Bella Fullilove'})
        
    def test_removeExistingAttendee(self):
        self.meetings[0].removeAttendee('Gala Peel')
        self.assertEqual(self.meetings[0].attendees(),{'Bella Fullilove', 'Ardella Gaillard'})
        
    def test_removeNonExistingAttendee(self):
        #should raise an ValueError  
        #self.meetings[0].removeAttendee('Matthew Gregory')
        #modified version that actually tests for this exception  
        self.assertRaises(ValueError,self.meetings[0].removeAttendee,'Matthew Gregory')
        
    def test_writeMeetings(self):
        writeMeetings(self.meetings,'Bella Fullilove')
        #test file exsit once we have run the writeMeeting function
        self.assertTrue(os.path.exists('meetings.txt'))#Don't forget to import os.path
        
if __name__ == '__main__':
    unittest.main()
